/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.core.lua.errorinfo;

import com.google.common.annotations.VisibleForTesting;
import dan200.computercraft.core.lua.errorinfo.DebugHelpers;
import java.util.Objects;
import org.jspecify.annotations.Nullable;
import org.squiddev.cobalt.CachedMetamethod;
import org.squiddev.cobalt.Constants;
import org.squiddev.cobalt.Lua;
import org.squiddev.cobalt.LuaError;
import org.squiddev.cobalt.LuaState;
import org.squiddev.cobalt.LuaString;
import org.squiddev.cobalt.LuaTable;
import org.squiddev.cobalt.LuaThread;
import org.squiddev.cobalt.LuaValue;
import org.squiddev.cobalt.Prototype;
import org.squiddev.cobalt.ValueFactory;
import org.squiddev.cobalt.Varargs;
import org.squiddev.cobalt.debug.DebugFrame;
import org.squiddev.cobalt.function.LuaFunction;
import org.squiddev.cobalt.function.RegisteredFunction;

public class ErrorInfoLib {
    private static final int MAX_DEPTH = 8;
    private static final RegisteredFunction[] functions = new RegisteredFunction[]{RegisteredFunction.ofV((String)"info_for_nil", ErrorInfoLib::getInfoForNil)};

    public static void add(LuaState state) throws LuaError {
        state.registry().getSubTable(Constants.LOADED).rawset("cc.internal.error_info", (LuaValue)RegisteredFunction.bind((RegisteredFunction[])functions));
    }

    private static Varargs getInfoForNil(LuaState state, Varargs args) throws LuaError {
        int level;
        LuaThread thread = args.arg(1).checkThread();
        NilInfo context = ErrorInfoLib.getInfoForNil(state, thread, level = args.arg(2).checkInteger());
        return context == null ? Constants.NIL : ValueFactory.varargsOf((LuaValue[])new LuaValue[]{ValueFactory.valueOf((String)context.op()), ValueFactory.valueOf((boolean)context.source().isGlobal()), context.source().table(), context.source().key()});
    }

    @VisibleForTesting
    static @Nullable NilInfo getInfoForNil(LuaState state, LuaThread thread, int level) {
        DebugFrame frame = thread.getDebugState().getFrame(level);
        if (frame == null || frame.closure == null || (frame.flags & 0x3C00) != 0) {
            return null;
        }
        Prototype prototype = frame.closure.getPrototype();
        int pc = frame.pc;
        int insn = prototype.code[pc];
        return switch (Lua.GET_OPCODE((int)insn)) {
            case 29, 30 -> NilInfo.of("call", ErrorInfoLib.resolveValueSource(state, frame, prototype, pc, Lua.GETARG_A((int)insn), 0));
            case 7, 10, 12 -> NilInfo.of("index", ErrorInfoLib.resolveValueSource(state, frame, prototype, pc, Lua.GETARG_A((int)insn), 0));
            default -> null;
        };
    }

    private static @Nullable ValueSource resolveValueSource(LuaState state, DebugFrame frame, Prototype prototype, int pc, int register, int depth) {
        if (depth > 8) {
            return null;
        }
        if (prototype.getLocalName(register + 1, pc) != null) {
            return null;
        }
        if ((pc = DebugHelpers.findSetReg(prototype, pc, register)) == -1) {
            return null;
        }
        int insn = prototype.code[pc];
        return switch (Lua.GET_OPCODE((int)insn)) {
            case 0 -> {
                int a = Lua.GETARG_A((int)insn);
                int b = Lua.GETARG_B((int)insn);
                if (b < a) {
                    yield ErrorInfoLib.resolveValueSource(state, frame, prototype, pc, register, depth + 1);
                }
                yield null;
            }
            case 6, 7, 12 -> {
                LuaValue table;
                int tableIndex = Lua.GETARG_B((int)insn);
                int keyIndex = Lua.GETARG_C((int)insn);
                if (!Lua.ISK((int)keyIndex)) {
                    yield null;
                }
                LuaValue key = prototype.constants[Lua.INDEXK((int)keyIndex)];
                if (key.type() != 4) {
                    yield null;
                }
                LuaValue v1 = table = Lua.GET_OPCODE((int)insn) == 6 ? frame.closure.getUpvalue(tableIndex).getValue() : ErrorInfoLib.evaluate(state, frame, prototype, pc, tableIndex, depth);
                if (table == null) {
                    yield null;
                }
                boolean isGlobal = Lua.GET_OPCODE((int)insn) == 6 && Objects.equals(prototype.getUpvalueName(tableIndex), Constants.ENV);
                yield new ValueSource(isGlobal, table, (LuaString)key);
            }
            default -> null;
        };
    }

    private static @Nullable LuaValue evaluate(LuaState state, DebugFrame frame, Prototype prototype, int pc, int register, int depth) {
        if (depth >= 8) {
            return null;
        }
        if (prototype.getLocalName(register + 1, pc) != null) {
            return frame.stack[register];
        }
        if ((pc = DebugHelpers.findSetReg(prototype, pc, register)) == -1) {
            return null;
        }
        int insn = prototype.code[pc];
        int opcode = Lua.GET_OPCODE((int)insn);
        return switch (opcode) {
            case 0 -> {
                int a = Lua.GETARG_A((int)insn);
                int b = Lua.GETARG_B((int)insn);
                if (b < a) {
                    yield ErrorInfoLib.evaluate(state, frame, prototype, pc, register, depth + 1);
                }
                yield null;
            }
            case 1 -> prototype.constants[Lua.GETARG_Bx((int)insn)];
            case 2 -> prototype.constants[Lua.GETARG_Ax((int)prototype.code[pc + 1])];
            case 3 -> {
                if (Lua.GETARG_B((int)insn) == 0) {
                    yield Constants.FALSE;
                }
                yield Constants.TRUE;
            }
            case 4 -> Constants.NIL;
            case 5 -> frame.closure.getUpvalue(Lua.GETARG_B((int)insn)).getValue();
            case 6, 7 -> {
                LuaValue table;
                LuaValue v1 = table = opcode == 6 ? frame.closure.getUpvalue(Lua.GETARG_B((int)insn)).getValue() : ErrorInfoLib.evaluate(state, frame, prototype, pc, Lua.GETARG_B((int)insn), depth + 1);
                if (table == null) {
                    yield null;
                }
                LuaValue key = ErrorInfoLib.evaluateK(state, frame, prototype, pc, Lua.GETARG_C((int)insn), depth + 1);
                if (key == null) {
                    yield null;
                }
                yield ErrorInfoLib.safeIndex(state, table, key);
            }
            default -> null;
        };
    }

    private static @Nullable LuaValue evaluateK(LuaState state, DebugFrame frame, Prototype prototype, int pc, int registerOrConstant, int depth) {
        return Lua.ISK((int)registerOrConstant) ? prototype.constants[Lua.INDEXK((int)registerOrConstant)] : ErrorInfoLib.evaluate(state, frame, prototype, pc, registerOrConstant, depth + 1);
    }

    private static @Nullable LuaValue safeIndex(LuaState state, LuaValue table, LuaValue key) {
        int loop = 0;
        do {
            LuaValue metatable;
            if (table instanceof LuaTable) {
                LuaTable tbl = (LuaTable)table;
                LuaValue res = tbl.rawget(key);
                if (!res.isNil() || (metatable = tbl.metatag(state, CachedMetamethod.INDEX)).isNil()) {
                    return res;
                }
            } else {
                metatable = table.metatag(state, CachedMetamethod.INDEX);
                if (metatable.isNil()) {
                    return null;
                }
            }
            if (metatable instanceof LuaFunction) {
                return null;
            }
            table = metatable;
        } while (++loop < 100);
        return null;
    }

    @VisibleForTesting
    record NilInfo(String op, ValueSource source) {
        public static @Nullable NilInfo of(String op, @Nullable ValueSource values) {
            return values == null ? null : new NilInfo(op, values);
        }
    }

    @VisibleForTesting
    record ValueSource(boolean isGlobal, LuaValue table, LuaString key) {
    }
}

